// (C)1997 Christian Janoff
// PKAT.CC

#include <iostream.h>
#include "c1541.h"
#include "file.h"
#include "pkstring.h"

int main(int argc,char *argv[])
{
  int to_zip=0,
      to_d64=0;

  c1541disk disk;

  pkstring cmdline[argc];
  for(int i=0;i<argc;i++)
    cmdline[i]=argv[i];

  cmdline[0].conv2basename();

  if (argc<2) {
		cerr << "Usage:   " << cmdline[0] << " [options | filenames]" << endl
                     << "Options: [-z]  convert to zipcode" << endl
		     << "         [-d]  convert to d64" << endl
		     << "         [-v]  verbose" << endl
		     << "         [-vv] more verbose" << endl
		     << "         [-y]  assume 'yes' on all queries" << endl;
		exit(1);
              }
  cout << "*** PK's Archive Tool V0.2 QH ***" << endl;

  for(int i=1;i<argc;i++)
    {
      if (cmdline[i].is("-v")) disk.set_verbose(1);
      else if (cmdline[i].is("-vv")) disk.set_more_verbose(1);
      else if (cmdline[i].is("-y")) disk.set_yes(1);
    }

  for(int i=1;i<argc;i++)
    {
      if (cmdline[i].is("-z")) {to_zip=1; to_d64=0;}
      else if (cmdline[i].is("-v")) ;
      else if (cmdline[i].is("-vv")) ;
      else if (cmdline[i].is("-y")) ;
      else if (cmdline[i].is("-d")) {to_d64=1; to_zip=0;}
      else
           if (to_zip==1)
		{ disk.d64(cmdline[i].string(),READ);
		  disk.zipcode(cmdline[i].string(),WRITE);
		}
           else
           if (to_d64==1)
                { disk.zipcode(cmdline[i].string(),READ);
		  disk.d64(cmdline[i].string(),WRITE);
                }
           else {
                  cerr << "No target specified! (use -z or -d)" << endl;
		  exit(1);
                }
    }

exit(0);
}
